import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;

import net.opro.product.odcaw.oproarts.api.*;

/**
 * OPROARTS APIの基本的な使い方を説明することを目的としたサンプルプログラムです。
 */
public class sample {
	public static void main(String[] args) {
		//OPROARTSでドキュメントを作成し、ファイルに保存するサンプルです。
		saveDocument();

		//OPROARTSでドキュメントを作成し、クライアントのプリンタに印刷するサンプルです。
		printDocument();

		//OPROARTSでドキュメントを作成し、ドキュメントを添付したメールを送信するサンプルです。
		sendMail();
	}


   /**
    * OPROARTSでドキュメントを作成し、ファイルに保存するサンプルです。
    */
	static void saveDocument() {
		URL oproartsUrl;
		try {
			oproartsUrl = new URL("https://www.oproarts.com/Facade");
		} catch (MalformedURLException e) {
			e.printStackTrace();
			return;
		}

		Reader templateData = getReader();
		try {

			//OPROARTSのURLを指定します。
			OPROARTSHandler handler = new OPROARTSHandler(oproartsUrl);

			//ドキュメント生成のためのパラメータを構築します。
			//弊社から送付された認証情報が必要です。
			String cid = "弊社から送付されたCID";
			String uid = "弊社から送付されたUID";
			String upw = "弊社から送付されたUPW";
			OPROARTSParameter parameter = new OPROARTSParameter(cid, uid, upw);

			//PDF形式のドキュメントを生成します。
			parameter.setFormat(OPROARTSHandler.FORMAT_PDF);

			//テンプレートに関するパラメータを構築します。
			TemplateParameter template = parameter.addTemplate();
			//テンプレート名
			template.setName("テンプレート名");
			//使用するデータを設定します。
			template.addData(templateData);

			//複数のテンプレートを指定することも可能です。
			//TemplateParameter tp2 = p.addTemplate();
			//tp2.setName("テンプレート名2");
			//tp2.addData(templateData2);

			try {
				//ドキュメントの生成と保存を指示します。
				String dir = "ドキュメントを保存するディレクトリのパス";
				String name = "保存するファイル名";
				String savedPath = handler.saveDocument(parameter, dir, name);
				System.out.println("保存されました。" + savedPath);
				System.out.println("ページ数は" + parameter.lastResponseInfo().getPageCount() + "です。");

			//サーバーサイドの例外
			} catch (OPROARTSUnAuthorizedException e) {
				//OPROARTSで認証エラーが発生。
				//OPROARTSParameterのコンストラクタに渡した認証情報を確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSRestrictedException e) {
				//OPROARTSで利用可能頁数エラーが発生。
				//契約期間内の利用頁数が、利用可能頁数の上限に達しています。
				e.printStackTrace();
				return;
			} catch (OPROARTSConcurrentRequestException e) {
				//OPROARTSで同時処理エラーが発生。
				//同じCID/UIDによる他の処理が、OPROARTSで実行中です。
				e.printStackTrace();
				return;
			} catch (OPROARTSIllegalRequestException e) {
				//OPROARTSでパラメータの整合性に関する問題が見つかった。
				//必須パラメータが指定されていないか、パラメータの内容が不正です。
				e.printStackTrace();
				return;
			} catch (OPROARTSRequestTooLargeException e) {
				//OPROARTSでデータサイズ超過エラーが発生。
				//パラメータで使用したデータの総量が、一つの処理に許されるデータサイズの上限値に達しています。
				e.printStackTrace();
				return;
			} catch (OPROARTSException e) {
				//OPROARTSでその他のエラーが発生。
				e.printStackTrace();
				return;

			//クライアントサイドの例外
			} catch (OPROARTSAPIConnectTimeoutException e) {
				//OPROARTSへの接続を確立する前にタイムアウトが発生。
				//ネットワーク状況などを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPIReadTimeoutException e) {
				//OPROARTSからデータを読み取る準備ができる前にタイムアウトが発生。
				//ネットワーク状況などを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPIConnectionException e) {
				//OPROARTSとの接続時にエラーが発生。
				//ネットワーク状況などを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPISavingException e) {
				//OPROARTS APIがドキュメントを保存する際に、エラーが発生。
				//アプリケーションから指定したファイルが作成可能かなどを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPIException e) {
				//OPROARTS APIでその他のエラーが発生。
				e.printStackTrace();
				return;
			}

		} finally {
			try {
				templateData.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}


	/**
	 * OPROARTSでドキュメントを作成し、クライアントのプリンタに印刷するサンプルです。
	 * クライアントの環境がWindows環境である必要があり、クライアントにOPRO X Browserがインストールされている必要があります。
	 * OPRO X Browserは弊社ウェブサイト（http://www.opro.net/）からダウンロードできます。
	 */
	static void printDocument() {
		URL oproartsUrl;
		try {
			oproartsUrl = new URL("https://www.oproarts.com/Facade");
		} catch (MalformedURLException e) {
			e.printStackTrace();
			return;
		}

		String savedPath;

		Reader templateData = getReader();
		try {

			//OPROARTSのURLを指定します。
			OPROARTSHandler handler = new OPROARTSHandler(oproartsUrl);

			//ドキュメント生成のためのパラメータを構築します。
			//弊社から送付された認証情報が必要です。
			String cid = "弊社から送付されたCID";
			String uid = "弊社から送付されたUID";
			String upw = "弊社から送付されたUPW";
			OPROARTSParameter parameter = new OPROARTSParameter(cid, uid, upw);

			//テンプレートに関するパラメータを構築します。
			TemplateParameter template = parameter.addTemplate();
			//テンプレート名
			template.setName("テンプレート名");
			//使用するデータを設定します。
			template.addData(templateData);

			//複数のテンプレートを指定することも可能です。
			//TemplateParameter tp2 = p.addTemplate();
			//tp2.setName("テンプレート名2");
			//tp2.addData(templateData2);

			//印刷用ドキュメントの生成と保存を指示します。
			try {
				String dir = "ドキュメントを保存するディレクトリのパス";
				String name = "保存するファイル名";
				savedPath = handler.saveDirectPrintDocument(parameter, dir, name);
				System.out.println("保存されました。" + savedPath);
				System.out.println("ページ数は" + parameter.lastResponseInfo().getPageCount() + "です。");

			//サーバーサイドの例外
			} catch (OPROARTSUnAuthorizedException e) {
				//OPROARTSで認証エラーが発生。
				//OPROARTSParameterのコンストラクタに渡した認証情報を確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSRestrictedException e) {
				//OPROARTSで利用可能頁数エラーが発生。
				//契約期間内の利用頁数が、利用可能頁数の上限に達しています。
				e.printStackTrace();
				return;
			} catch (OPROARTSConcurrentRequestException e) {
				//OPROARTSで同時処理エラーが発生。
				//同じCID/UIDによる他の処理が、OPROARTSで実行中です。
				e.printStackTrace();
				return;
			} catch (OPROARTSIllegalRequestException e) {
				//OPROARTSでパラメータの整合性に関する問題が見つかった。
				//必須パラメータが指定されていないか、パラメータの内容が不正です。
				e.printStackTrace();
				return;
			} catch (OPROARTSRequestTooLargeException e) {
				//OPROARTSでデータサイズ超過エラーが発生。
				//パラメータで使用したデータの総量が、一つの処理に許されるデータサイズの上限値に達しています。
				e.printStackTrace();
				return;
			} catch (OPROARTSException e) {
				//OPROARTSでその他のエラーが発生。
				e.printStackTrace();
				return;

			//クライアントサイドの例外
			} catch (OPROARTSAPIConnectTimeoutException e) {
				//OPROARTSへの接続を確立する前にタイムアウトが発生。
				//ネットワーク状況などを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPIReadTimeoutException e) {
				//OPROARTSからデータを読み取る準備ができる前にタイムアウトが発生。
				//ネットワーク状況などを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPIConnectionException e) {
				//OPROARTSとの接続時にエラーが発生。
				//ネットワーク状況などを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPISavingException e) {
				//OPROARTS APIがドキュメントを保存する際に、エラーが発生。
				//アプリケーションから指定したファイルが作成可能かなどを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPIException e) {
				//OPROARTS APIでその他のエラーが発生。
				e.printStackTrace();
				return;
			}

		} finally {
			try {
				templateData.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

		//保存されたドキュメントはODP形式で、OPRO X Browserで印刷することができます。
		try {
			Process process = Runtime.getRuntime().exec(new String[]{"cmd", "/c", savedPath});
			process.waitFor();
			System.out.println("印刷されました。");
			//OPRO X Browserの標準の設定では、ドキュメントは印刷後に削除されます。
		} catch (IOException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}


   /**
    * OPROARTSでドキュメントを作成し、ドキュメントを添付したメールを送信するサンプルです。
    */
	static void sendMail() {
		URL oproartsUrl;
		try {
			oproartsUrl = new URL("https://www.oproarts.com/Facade");
		} catch (MalformedURLException e) {
			e.printStackTrace();
			return;
		}

		Reader templateData = getReader();
		try {

			//OPROARTSのURLを指定します。
			OPROARTSHandler handler = new OPROARTSHandler(oproartsUrl);

			//ドキュメント生成のためのパラメータを構築します。
			//弊社から送付された認証情報が必要です。
			String cid = "弊社から送付されたCID";
			String uid = "弊社から送付されたUID";
			String upw = "弊社から送付されたUPW";
			OPROARTSParameter parameter = new OPROARTSParameter(cid, uid, upw);

			//PDF形式のドキュメントを生成します。
			parameter.setFormat(OPROARTSHandler.FORMAT_PDF);

			//テンプレートに関するパラメータを構築します。
			TemplateParameter template = parameter.addTemplate();
			//テンプレート名
			template.setName("テンプレート名");
			//使用するデータを設定します。
			template.addData(templateData);

			//複数のテンプレートを指定することも可能です。
			//TemplateParameter tp2 = p.addTemplate();
			//tp2.setName("テンプレート名2");
			//tp2.addData(templateData2);

			//メール送信に関するパラメータを構築します。
			MailParameter mail = new MailParameter();
			parameter.setMail(mail);
			//From
			mail.setFrom("from@example.com");
			//To
			mail.addTo("to@example.com");
			//件名
			mail.setSubject("件名");
			//本文
			mail.setBody("本文");
			//添付ファイル名
			mail.setAttachName("添付ファイル名");

			try {
				//ドキュメントを添付したメールを送信します。
				handler.sendMail(parameter);
				System.out.println("ページ数は" + parameter.lastResponseInfo().getPageCount() + "です。");

			//サーバーサイドの例外
			} catch (OPROARTSUnAuthorizedException e) {
				//OPROARTSで認証エラーが発生。
				//OPROARTSParameterのコンストラクタに渡した認証情報を確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSRestrictedException e) {
				//OPROARTSで利用可能頁数エラーが発生。
				//契約期間内の利用頁数が、利用可能頁数の上限に達しています。
				e.printStackTrace();
				return;
			} catch (OPROARTSConcurrentRequestException e) {
				//OPROARTSで同時処理エラーが発生。
				//同じCID/UIDによる他の処理が、OPROARTSで実行中です。
				e.printStackTrace();
				return;
			} catch (OPROARTSIllegalRequestException e) {
				//OPROARTSでパラメータの整合性に関する問題が見つかった。
				//必須パラメータが指定されていないか、パラメータの内容が不正です。
				e.printStackTrace();
				return;
			} catch (OPROARTSRequestTooLargeException e) {
				//OPROARTSでデータサイズ超過エラーが発生。
				//パラメータで使用したデータの総量が、一つの処理に許されるデータサイズの上限値に達しています。
				e.printStackTrace();
				return;
			} catch (OPROARTSException e) {
				//OPROARTSでその他のエラーが発生。
				e.printStackTrace();
				return;

			//クライアントサイドの例外
			} catch (OPROARTSAPIConnectTimeoutException e) {
				//OPROARTSへの接続を確立する前にタイムアウトが発生。
				//ネットワーク状況などを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPIReadTimeoutException e) {
				//OPROARTSからデータを読み取る準備ができる前にタイムアウトが発生。
				//ネットワーク状況などを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPIConnectionException e) {
				//OPROARTSとの接続時にエラーが発生。
				//ネットワーク状況などを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPISavingException e) {
				//OPROARTS APIがドキュメントを保存する際に、エラーが発生。
				//アプリケーションから指定したファイルが作成可能かなどを確認してください。
				e.printStackTrace();
				return;
			} catch (OPROARTSAPIException e) {
				//OPROARTS APIでその他のエラーが発生。
				e.printStackTrace();
				return;
			}

		} finally {
			try {
				templateData.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}


	/**
	 * OPROARTSで使用するCSVデータを、Readerで返すメソッドを想定しています。
	 * 実装は要件によって異なり、OPROARTS APIの説明とは離れますので、ここでは実装を省略します。
	 */
	static Reader getReader() {
		return new StringReader("dummy");
	}
}
