/*
 * Decompiled with CFR 0.152.
 */
package net.opro.product.odcaw.oproarts.api;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.opro.product.odcaw.oproarts.api.AttachedParameter;
import net.opro.product.odcaw.oproarts.api.MailParameter;
import net.opro.product.odcaw.oproarts.api.OPROARTSResponseInfo;
import net.opro.product.odcaw.oproarts.api.StreamAttachedParameter;
import net.opro.product.odcaw.oproarts.api.TemplateParameter;
import net.opro.product.odcaw.oproarts.api.TextAttachedParameter;

public class OPROARTSParameter {
    private String cid = null;
    private String uid = null;
    private String upw = null;
    private int format = 2;
    private boolean fe = false;
    private final List<TemplateParameter> templateParameters = new ArrayList<TemplateParameter>();
    private final List<AttachedParameter> attachedParameters = new ArrayList<AttachedParameter>();
    private MailParameter mailParameter = null;
    private OPROARTSResponseInfo lastResponseInfo;
    private String dit;
    private String dia;
    private String dis;
    private String dik;
    private boolean preview = false;
    private final Map<String, String> additionalParams = new LinkedHashMap<String, String>();

    public OPROARTSParameter(String cid, String uid, String password) {
        this();
        this.setAuthentication(cid, uid, password);
    }

    public OPROARTSParameter() {
        this.templateParameters.clear();
        this.mailParameter = null;
    }

    public void setAuthentication(String cid, String uid, String password) {
        this.cid = cid;
        this.uid = uid;
        this.upw = password;
    }

    public void setFormat(int value) {
        this.format = value;
    }

    public int getFormat() {
        return this.format;
    }

    public TemplateParameter addTemplate() {
        TemplateParameter tp = new TemplateParameter();
        this.templateParameters.add(tp);
        return tp;
    }

    public TemplateParameter addTemplate(String value) {
        TemplateParameter tp = new TemplateParameter();
        tp.setName(value);
        this.templateParameters.add(tp);
        return tp;
    }

    public int sizeTemplate() {
        return this.templateParameters.size();
    }

    public TemplateParameter templateAt(int index) {
        return this.templateParameters.get(index);
    }

    public void removeTemplate(int index) {
        this.templateParameters.remove(index);
    }

    public void setMail(MailParameter mailParameter) {
        this.mailParameter = mailParameter;
    }

    public MailParameter getMail() {
        return this.mailParameter;
    }

    public TextAttachedParameter addTextAttached() {
        TextAttachedParameter a = new TextAttachedParameter();
        this.attachedParameters.add(a);
        return a;
    }

    public TextAttachedParameter addTextAttached(String content, String name, String charset) {
        TextAttachedParameter a = this.addTextAttached();
        a.setContent(content);
        a.setName(name);
        a.setCharset(charset);
        return a;
    }

    public TextAttachedParameter addTextAttached(Reader content, String name, String charset) {
        TextAttachedParameter a = this.addTextAttached();
        a.setContent(content);
        a.setName(name);
        a.setCharset(charset);
        return a;
    }

    public StreamAttachedParameter addStreamAttached() {
        StreamAttachedParameter a = new StreamAttachedParameter();
        this.attachedParameters.add(a);
        return a;
    }

    public StreamAttachedParameter addStreamAttached(InputStream content, String name) {
        StreamAttachedParameter a = this.addStreamAttached();
        a.setContent(content);
        a.setName(name);
        return a;
    }

    public int sizeAttached() {
        return this.attachedParameters.size();
    }

    public void removeAttached(int index) {
        this.attachedParameters.remove(index);
    }

    public AttachedParameter attachedAt(int index) {
        return this.attachedParameters.get(index);
    }

    protected List<AttachedParameter> getAttachedParameters() {
        return this.attachedParameters;
    }

    public void setFontEmbedding(boolean value) {
        this.fe = value;
    }

    public boolean getFontEmbedding() {
        return this.fe;
    }

    public String getDocumentTitle() {
        return this.dit;
    }

    public void setDocumentTitle(String documentTitle) {
        this.dit = documentTitle;
    }

    public String getDocumentAuthor() {
        return this.dia;
    }

    public void setDocumentAuthor(String documentAuthor) {
        this.dia = documentAuthor;
    }

    public String getDocumentSubtitle() {
        return this.dis;
    }

    public void setDocumentSubtitle(String documentSubtitle) {
        this.dis = documentSubtitle;
    }

    public String getDocumentKeyword() {
        return this.dik;
    }

    public void setDocumentKeyword(String documentKeyword) {
        this.dik = documentKeyword;
    }

    public boolean getPreview() {
        return this.preview;
    }

    public void setPreview(boolean value) {
        this.preview = value;
    }

    public OPROARTSResponseInfo lastResponseInfo() {
        return this.lastResponseInfo != null ? this.lastResponseInfo : OPROARTSResponseInfo.NULLINFO;
    }

    protected void setResponseInfo(OPROARTSResponseInfo value) {
        this.lastResponseInfo = value;
    }

    protected String getCid() {
        return this.cid;
    }

    protected String getUid() {
        return this.uid;
    }

    protected String getUpw() {
        return this.upw;
    }

    protected List<TemplateParameter> getTemplateParameters() {
        return this.templateParameters;
    }

    protected void setAdditionalParams(Map<String, String> value) {
        this.additionalParams.clear();
        if (value != null) {
            this.additionalParams.putAll(value);
        }
    }

    protected Map<String, String> additionalParams() {
        return this.additionalParams;
    }
}

