/*
 * Decompiled with CFR 0.152.
 */
package net.opro.product.odcaw.oproarts.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opro.product.odcaw.oproarts.misc.WriterURLEncoder;

public class OPROARTSResponseInfo {
    static final OPROARTSResponseInfo NULLINFO = new OPROARTSResponseInfo(null);
    private final Map<String, String> artsHeaderMap = new HashMap<String, String>();
    private final String contentType;
    private final long contentLength;

    OPROARTSResponseInfo(Map<String, List<String>> headers) {
        String _contentLength;
        if (headers == null) {
            this.contentType = null;
            this.contentLength = -1L;
            return;
        }
        List<String> values = headers.get("X-OPROARTS");
        if (values != null) {
            for (String s : values) {
                String name;
                if (s == null || s.length() == 0) continue;
                String value = null;
                int eq = s.indexOf(61);
                if (eq > 0) {
                    name = s.substring(0, eq);
                    if (eq + 1 < s.length()) {
                        value = s.substring(eq + 1);
                    }
                } else {
                    name = s;
                }
                this.artsHeaderMap.put(name, value);
            }
        }
        this.contentType = (values = headers.get("Content-Type")) != null && !values.isEmpty() ? values.get(0) : null;
        values = headers.get("Content-Length");
        long contentLength = -1L;
        String string = _contentLength = values != null && !values.isEmpty() ? values.get(0) : null;
        if (_contentLength != null && !_contentLength.isEmpty()) {
            try {
                contentLength = Long.parseLong(_contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.contentLength = contentLength;
    }

    public int getPageCount() {
        String result = this.artsHeaderMap.get("PAGES");
        try {
            if (result != null && result.length() > 0) {
                return Integer.parseInt(result, 10);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public String getRequestId() {
        return this.artsHeaderMap.get("REQUESTID");
    }

    protected String getFileName() {
        String result = this.artsHeaderMap.get("FILENAME");
        return result != null ? WriterURLEncoder.decode(result) : null;
    }

    protected String getErrorMessage() {
        String result = this.artsHeaderMap.get("ERROR_MESSAGE");
        return result != null ? WriterURLEncoder.decode(result) : null;
    }

    protected long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }
}

