/*
 * Decompiled with CFR 0.152.
 */
package net.opro.product.odcaw.oproarts.misc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import net.opro.product.odcaw.oproarts.misc.SimpleWriter;

public class Base64 {
    private static final char[] encodeMap = new char[64];
    private static final byte[] decodeMap;

    static {
        int i = 0;
        int c = 65;
        while (c <= 90) {
            Base64.encodeMap[i++] = c;
            c = (char)(c + 1);
        }
        c = 97;
        while (c <= 122) {
            Base64.encodeMap[i++] = c;
            c = (char)(c + 1);
        }
        c = 48;
        while (c <= 57) {
            Base64.encodeMap[i++] = c;
            c = (char)(c + 1);
        }
        Base64.encodeMap[i++] = 43;
        Base64.encodeMap[i++] = 47;
        decodeMap = new byte[128];
        i = 0;
        while (i < decodeMap.length) {
            Base64.decodeMap[i] = -1;
            ++i;
        }
        i = 0;
        while (i < encodeMap.length) {
            Base64.decodeMap[Base64.encodeMap[i]] = (byte)i;
            ++i;
        }
    }

    public static final byte[] encode(byte[] data, boolean needPadding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Base64.encodeTo(data, (OutputStream)out, needPadding, false);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    public static final long encodeTo(byte[] in, OutputStream out, boolean needPadding, boolean needURLEncode) throws IOException {
        if (in == null) {
            return 0L;
        }
        if (in.length == 0) {
            return 0L;
        }
        ByteArrayInputStream _in = new ByteArrayInputStream(in);
        try {
            long l = Base64.encodeTo((InputStream)_in, out, needPadding, needURLEncode);
            return l;
        }
        finally {
            _in.close();
        }
    }

    public static final long encodeTo(InputStream in, OutputStream out, boolean needPadding, boolean needURLEncode) throws IOException {
        if (in == null) {
            return 0L;
        }
        return Base64.encodeTo(in, new SimpleWriter(new BufferedOutputStream(out)), needPadding, needURLEncode);
    }

    public static final long encodeTo(InputStream in, Writer out, boolean needPadding, boolean needURLEncode) throws IOException {
        int read;
        if (in == null) {
            return 0L;
        }
        CountableWriter _out = needURLEncode ? new UrlEncodeWriter(out) : new CountableWriter(out);
        BufferedInputStream _in = new BufferedInputStream(in);
        while ((read = _in.read()) != -1) {
            int i0 = read & 0xFF;
            read = _in.read();
            boolean b1 = read != -1;
            int i1 = b1 ? read & 0xFF : 0;
            read = _in.read();
            boolean b2 = read != -1;
            int i2 = b2 ? read & 0xFF : 0;
            _out.write(encodeMap[i0 >>> 2]);
            _out.write(encodeMap[(i0 & 3) << 4 | i1 >>> 4]);
            if (b1) {
                _out.write(encodeMap[(i1 & 0xF) << 2 | i2 >>> 6]);
            } else if (needPadding) {
                _out.write(61);
            }
            if (b2) {
                _out.write(encodeMap[i2 & 0x3F]);
                continue;
            }
            if (!needPadding) continue;
            _out.write(61);
        }
        _out.flush();
        return _out.getCount();
    }

    public static final byte[] decode(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Base64.decodeTo(data, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final int decodeTo(byte[] in, OutputStream out) throws IOException {
        if (in == null) {
            return 0;
        }
        inLen = in.length;
        if (inLen >= 2) ** GOTO lbl7
        throw new IOException("Length of Base64 encoded data is invalid.");
lbl-1000:
        // 1 sources

        {
            --inLen;
lbl7:
            // 2 sources

            ** while (in[inLen - 1] == 61)
        }
lbl8:
        // 1 sources

        outLen = inLen * 3 / 4;
        if (outLen <= 0) {
            return 0;
        }
        _out = new BufferedOutputStream(out);
        i = 0;
        while (i < inLen) {
            i0 = in[i++];
            i1 = in[i++];
            b2 = i < inLen;
            i2 = b2 != false ? in[i++] : Base64.encodeMap[0];
            b3 = i < inLen;
            i3 = b3 != false ? in[i++] : Base64.encodeMap[0];
            Base64.writeDecode(_out, i0, i1, i2, i3, b2, b3);
        }
        _out.flush();
        return outLen;
    }

    /*
     * Unable to fully structure code
     */
    public static final int decodeTo(String in, OutputStream out) throws IOException {
        if (in == null) {
            return 0;
        }
        inLen = in.length();
        if (inLen >= 2) ** GOTO lbl7
        throw new IOException("Length of Base64 encoded data is invalid.");
lbl-1000:
        // 1 sources

        {
            --inLen;
lbl7:
            // 2 sources

            ** while (in.charAt((int)(inLen - 1)) == '=')
        }
lbl8:
        // 1 sources

        outLen = inLen * 3 / 4;
        if (outLen <= 0) {
            return 0;
        }
        _out = new BufferedOutputStream(out);
        i = 0;
        while (i < inLen) {
            i0 = in.charAt(i++);
            i1 = in.charAt(i++);
            b2 = i < inLen;
            i2 = b2 != false ? in.charAt(i++) : Base64.encodeMap[0];
            b3 = i < inLen;
            i3 = b3 != false ? in.charAt(i++) : Base64.encodeMap[0];
            Base64.writeDecode(_out, i0, i1, i2, i3, b2, b3);
        }
        _out.flush();
        return outLen;
    }

    private static void writeDecode(OutputStream out, int i0, int i1, int i2, int i3, boolean b2, boolean b3) throws IOException {
        if (i0 < 0 || i1 < 0 || i2 < 0 || i3 < 0) {
            throw new IOException("Illegal value in Base64 encoded data.");
        }
        byte o0 = decodeMap[i0];
        byte o1 = decodeMap[i1];
        byte o2 = decodeMap[i2];
        byte o3 = decodeMap[i3];
        if (o0 < 0 || o1 < 0 || o2 < 0 || o3 < 0) {
            throw new IOException("Illegal value in Base64 encoded data.");
        }
        out.write(o0 << 2 | o1 >>> 4);
        if (b2) {
            out.write((o1 & 0xF) << 4 | o2 >>> 2);
            if (b3) {
                out.write((o2 & 3) << 6 | o3);
            }
        }
    }

    private static class CountableWriter
    extends BufferedWriter {
        private long count = 0L;

        public CountableWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            super.write(cbuf, off, len);
            this.count += (long)len;
        }

        @Override
        public void write(int c) throws IOException {
            super.write(c);
            ++this.count;
        }

        @Override
        public void write(String s, int off, int len) throws IOException {
            super.write(s, off, len);
            this.count += (long)len;
        }

        public long getCount() {
            return this.count;
        }
    }

    private static class UrlEncodeWriter
    extends CountableWriter {
        private static final char[] urlEncodedPlus = new char[]{'%', '2', 'B'};
        private static final char[] urlEncodedSlash = new char[]{'%', '2', 'F'};
        private static final char[] urlEncodedEqual = new char[]{'%', '3', 'D'};

        public UrlEncodeWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(int c) throws IOException {
            switch (c) {
                case 43: {
                    super.write(urlEncodedPlus, 0, urlEncodedPlus.length);
                    return;
                }
                case 47: {
                    super.write(urlEncodedSlash, 0, urlEncodedSlash.length);
                    return;
                }
                case 61: {
                    super.write(urlEncodedEqual, 0, urlEncodedEqual.length);
                    return;
                }
            }
            super.write(c);
        }
    }
}

