/*
 * Decompiled with CFR 0.152.
 */
package net.opro.product.odcaw.oproarts.misc;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;

public class WriterURLEncoder {
    private static final int needToEncodeBufferSize = 256;
    private static final BitSet dontNeedEncoding;
    private static final int caseDiff = 32;
    private static final Charset UTF8;

    static {
        UTF8 = Charset.forName("UTF-8");
        dontNeedEncoding = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            dontNeedEncoding.set(i);
            ++i;
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }

    private static Charset toCharset(String s) throws UnsupportedEncodingException {
        try {
            return Charset.forName(s);
        }
        catch (IllegalCharsetNameException e) {
            throw new UnsupportedEncodingException(s);
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(s);
        }
    }

    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static void encode(String s, Writer out, String enc) throws IOException, UnsupportedEncodingException {
        WriterURLEncoder.encode(s, out, WriterURLEncoder.toCharset(enc));
    }

    public static void encode(String s, Writer out) throws IOException {
        WriterURLEncoder.encode(s, out, UTF8);
    }

    public static void encode(String s, Writer out, Charset charset) throws IOException {
        WriterURLEncoder.doEncode(new StringReaderPseudo(s), out, UTF8);
    }

    public static void encode(Reader in, Writer out, String enc) throws IOException, UnsupportedEncodingException {
        WriterURLEncoder.encode(in, out, WriterURLEncoder.toCharset(enc));
    }

    public static void encode(Reader in, Writer out) throws IOException {
        WriterURLEncoder.encode(in, out, UTF8);
    }

    public static void encode(Reader in, Writer out, Charset charset) throws IOException {
        WriterURLEncoder.doEncode(new ReaderReaderPseudo(in), out, UTF8);
    }

    private static void doEncode(ReaderPseudo in, Writer out, Charset charset) throws IOException {
        CharArrayWriter buf = new CharArrayWriter();
        int c = in.read();
        while (c != -1) {
            if (dontNeedEncoding.get(c)) {
                if (c == 32) {
                    c = 43;
                }
                out.write(c);
                c = in.read();
                continue;
            }
            do {
                buf.write(c);
                int c0 = c;
                c = in.read();
                if (c != -1 && c0 >= 55296 && c0 <= 56319 && c >= 56320 && c <= 57343) {
                    buf.write(c);
                    c = in.read();
                }
                if (buf.size() <= 256) continue;
                WriterURLEncoder.writeEncoded(buf, charset, out);
            } while (c != -1 && !dontNeedEncoding.get(c));
            if (buf.size() <= 0) continue;
            WriterURLEncoder.writeEncoded(buf, charset, out);
        }
    }

    protected static void writeEncoded(CharArrayWriter buf, Charset charset, Writer out) throws IOException {
        buf.flush();
        byte[] ba = buf.toString().getBytes(charset);
        int j = 0;
        while (j < ba.length) {
            out.write(37);
            char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
            if (Character.isLetter(ch)) {
                ch = (char)(ch - 32);
            }
            out.write(ch);
            ch = Character.forDigit(ba[j] & 0xF, 16);
            if (Character.isLetter(ch)) {
                ch = (char)(ch - 32);
            }
            out.write(ch);
            ++j;
        }
        buf.reset();
    }

    private static interface ReaderPseudo {
        public int read() throws IOException;
    }

    private static class ReaderReaderPseudo
    implements ReaderPseudo {
        final Reader r;

        ReaderReaderPseudo(Reader r) {
            this.r = r;
        }

        @Override
        public int read() throws IOException {
            return this.r.read();
        }
    }

    private static class StringReaderPseudo
    implements ReaderPseudo {
        final String s;
        final int length;
        int index;

        StringReaderPseudo(String s) {
            this.s = s;
            this.length = s.length();
            this.index = 0;
        }

        @Override
        public int read() {
            return this.index < this.length ? (int)this.s.charAt(this.index++) : -1;
        }
    }
}

