/*
 * Decompiled with CFR 0.152.
 */
package net.opro.product.odcaw.oproarts.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.opro.product.odcaw.oproarts.api.AttachedParameter;
import net.opro.product.odcaw.oproarts.api.MailParameter;
import net.opro.product.odcaw.oproarts.api.OPROARTSAPIConnectTimeoutException;
import net.opro.product.odcaw.oproarts.api.OPROARTSAPIConnectionException;
import net.opro.product.odcaw.oproarts.api.OPROARTSAPIException;
import net.opro.product.odcaw.oproarts.api.OPROARTSAPIFileSizeException;
import net.opro.product.odcaw.oproarts.api.OPROARTSAPIReadTimeoutException;
import net.opro.product.odcaw.oproarts.api.OPROARTSAPISavingException;
import net.opro.product.odcaw.oproarts.api.OPROARTSCanceledException;
import net.opro.product.odcaw.oproarts.api.OPROARTSConcurrentRequestException;
import net.opro.product.odcaw.oproarts.api.OPROARTSException;
import net.opro.product.odcaw.oproarts.api.OPROARTSIllegalRequestException;
import net.opro.product.odcaw.oproarts.api.OPROARTSParameter;
import net.opro.product.odcaw.oproarts.api.OPROARTSRequestTooLargeException;
import net.opro.product.odcaw.oproarts.api.OPROARTSResponseInfo;
import net.opro.product.odcaw.oproarts.api.OPROARTSRestrictedException;
import net.opro.product.odcaw.oproarts.api.OPROARTSTimeoutException;
import net.opro.product.odcaw.oproarts.api.OPROARTSUnAuthorizedException;
import net.opro.product.odcaw.oproarts.api.TemplateParameter;
import net.opro.product.odcaw.oproarts.api.TextAttachedParameter;
import net.opro.product.odcaw.oproarts.misc.Base64;
import net.opro.product.odcaw.oproarts.misc.SimpleWriter;
import net.opro.product.odcaw.oproarts.misc.WriterURLEncoder;

public class OPROARTSHandler {
    public static final int FORMAT_OPR = 1;
    public static final int FORMAT_PDF = 2;
    protected static final int FORMAT_ODP = 3;
    public static final int FORMAT_EXCEL_MERGED = 4;
    public static final int FORMAT_EXCEL_MERGED_DCT = 5;
    public static final int FORMAT_WORD_MERGED_DCT = 6;
    public static final int FORMAT_EXCEL_MERGED_DDO = 7;
    public static final int FORMAT_WORD_MERGED_DDO = 8;
    private static final int[] PUBLIC_FORMAT = new int[]{1, 2, 4, 5, 6, 7, 8};
    protected static final int MODE_DOWNLOAD = 1;
    protected static final int MODE_MAIL = 2;
    protected static final int MODE_DIRECTPRINT = 4;
    protected static final String USERAGENT = "OPROARTSAPI:asyncable/2018.11.08";
    private final URL url;
    private final Proxy proxy;
    private final Map<String, String> additionalParams = new LinkedHashMap<String, String>();
    private String uaDetail;
    private Locale locale = null;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private boolean checkSavedSize = false;
    private static final TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }};
    private static final String REGEX_MAIL_ATOM = "[a-zA-Z0-9_!#\\$\\%&'*+/=?\\^`{}~|\\-]+";
    private static final String REGEX_MAIL_SPEC = "^[a-zA-Z0-9_!#\\$\\%&'*+/=?\\^`{}~|\\-]+(?:\\.[a-zA-Z0-9_!#\\$\\%&'*+/=?\\^`{}~|\\-]+)*\\.*\\@[a-zA-Z0-9_!#\\$\\%&'*+/=?\\^`{}~|\\-]+(?:\\.[a-zA-Z0-9_!#\\$\\%&'*+/=?\\^`{}~|\\-]+)+$";
    protected static final Pattern MAIL_ADDRESS = Pattern.compile("^[a-zA-Z0-9_!#\\$\\%&'*+/=?\\^`{}~|\\-]+(?:\\.[a-zA-Z0-9_!#\\$\\%&'*+/=?\\^`{}~|\\-]+)*\\.*\\@[a-zA-Z0-9_!#\\$\\%&'*+/=?\\^`{}~|\\-]+(?:\\.[a-zA-Z0-9_!#\\$\\%&'*+/=?\\^`{}~|\\-]+)+$");

    protected void setAdditionalParams(Map<String, String> value) {
        this.additionalParams.clear();
        if (value != null) {
            this.additionalParams.putAll(value);
        }
    }

    protected void setUaDetail(String value) {
        this.uaDetail = value;
    }

    public OPROARTSHandler(String url) throws MalformedURLException {
        this(new URL(url));
    }

    public OPROARTSHandler(URL url) {
        this(url, null);
    }

    public OPROARTSHandler(URL url, Proxy proxy) {
        this.url = url;
        this.proxy = proxy;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setCheckSavedSize(boolean checkSavedSize) {
        this.checkSavedSize = checkSavedSize;
    }

    public boolean isCheckSavedSize() {
        return this.checkSavedSize;
    }

    public String saveDocument(OPROARTSParameter parameter, String dir, String name) throws OPROARTSUnAuthorizedException, OPROARTSRestrictedException, OPROARTSConcurrentRequestException, OPROARTSIllegalRequestException, OPROARTSRequestTooLargeException, OPROARTSTimeoutException, OPROARTSCanceledException, OPROARTSException, OPROARTSAPIConnectTimeoutException, OPROARTSAPIReadTimeoutException, OPROARTSAPIConnectionException, OPROARTSAPISavingException, OPROARTSAPIException {
        OPROARTSHandler.checkParameter(parameter, true, true, false);
        if (dir == null) {
            dir = "";
        }
        if (name == null) {
            name = "";
        }
        OPROARTSHandler.checkSavable(dir, name, parameter.getFormat());
        return this.process(parameter, 1, dir, name);
    }

    public void sendMail(OPROARTSParameter parameter) throws OPROARTSUnAuthorizedException, OPROARTSRestrictedException, OPROARTSConcurrentRequestException, OPROARTSIllegalRequestException, OPROARTSRequestTooLargeException, OPROARTSTimeoutException, OPROARTSCanceledException, OPROARTSException, OPROARTSAPIConnectTimeoutException, OPROARTSAPIReadTimeoutException, OPROARTSAPIConnectionException, OPROARTSAPIException {
        OPROARTSHandler.checkParameter(parameter, true, true, true);
        this.process(parameter, 2, null, null);
    }

    public String saveDirectPrintDocument(OPROARTSParameter parameter, String dir, String name) throws OPROARTSUnAuthorizedException, OPROARTSRestrictedException, OPROARTSConcurrentRequestException, OPROARTSIllegalRequestException, OPROARTSRequestTooLargeException, OPROARTSTimeoutException, OPROARTSCanceledException, OPROARTSException, OPROARTSAPIConnectTimeoutException, OPROARTSAPIReadTimeoutException, OPROARTSAPIConnectionException, OPROARTSAPISavingException, OPROARTSAPIException {
        OPROARTSHandler.checkParameter(parameter, true, false, false);
        if (dir == null) {
            dir = "";
        }
        if (name == null) {
            name = "";
        }
        OPROARTSHandler.checkSavable(dir, name, 3);
        return this.process(parameter, 4, dir, name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkAuthentication(OPROARTSParameter parameter) throws OPROARTSException, OPROARTSAPIConnectTimeoutException, OPROARTSAPIReadTimeoutException, OPROARTSAPIConnectionException, OPROARTSAPIException {
        OPROARTSHandler.checkParameter(parameter, false, false, false);
        OPROARTSHTTPRequest httpRequest = new OPROARTSHTTPRequest(this.url, this.proxy, this.connectTimeout, this.readTimeout);
        httpRequest.setLocale(this.locale);
        httpRequest.setUaDetail(this.uaDetail);
        try {
            httpRequest.addParameter("OP", "m.exists");
            httpRequest.addParameter("CID", parameter.getCid());
            httpRequest.addParameter("UID", parameter.getUid());
            httpRequest.addParameter("UPW", parameter.getUpw());
            try {
                InputStream in = httpRequest.request();
                try {
                    in.close();
                    return true;
                }
                catch (IOException e) {
                    throw new OPROARTSAPIException(e);
                }
            }
            catch (OPROARTSException e) {
                if (e.getClass() != OPROARTSException.class) {
                    httpRequest.disconnect();
                    return false;
                }
                throw e;
            }
        }
        finally {
            httpRequest.disconnect();
        }
    }

    /*
     * WARNING - void declaration
     */
    private String process(OPROARTSParameter apiParam, int mode, String dir, String name) throws OPROARTSAPIException, OPROARTSException {
        OPROARTSHTTPRequest httpRequest = new OPROARTSHTTPRequest(this.url, this.proxy, this.connectTimeout, this.readTimeout);
        httpRequest.setLocale(this.locale);
        httpRequest.setUaDetail(this.uaDetail);
        try {
            void var7_14;
            block32: {
                long size;
                long contentLength;
                String string;
                String op;
                int n = apiParam.getFormat();
                switch (mode) {
                    case 4: {
                        op = "dp";
                        break;
                    }
                    case 2: {
                        op = n == 1 ? "mlo" : (n == 4 ? "mlxm" : (n == 5 ? "dmlxm" : (n == 6 ? "dmlwm" : (n == 7 ? "o.mlxm" : (n == 8 ? "o.mlwm" : "mlp")))));
                        break;
                    }
                    default: {
                        op = n == 1 ? "dlo" : (n == 4 ? "dlxm" : (n == 5 ? "ddlxm" : (n == 6 ? "ddlwm" : (n == 7 ? "o.dlxm" : (n == 8 ? "o.dlwm" : "dlp")))));
                    }
                }
                httpRequest.addParameter("OP", op);
                httpRequest.addParameter("CID", apiParam.getCid());
                httpRequest.addParameter("UID", apiParam.getUid());
                httpRequest.addParameter("UPW", apiParam.getUpw());
                httpRequest.addParameter("FE", "" + apiParam.getFontEmbedding());
                httpRequest.addParameterIfNotNull("DIT", apiParam.getDocumentTitle());
                httpRequest.addParameterIfNotNull("DIA", apiParam.getDocumentAuthor());
                httpRequest.addParameterIfNotNull("DIS", apiParam.getDocumentSubtitle());
                httpRequest.addParameterIfNotNull("DIK", apiParam.getDocumentKeyword());
                if (apiParam.getPreview() && (mode == 4 || mode == 1 && (apiParam.getFormat() == 2 || apiParam.getFormat() == 1))) {
                    httpRequest.addParameter("PV", "true");
                }
                int tpCount = 1;
                for (TemplateParameter templateParameter : apiParam.getTemplateParameters()) {
                    if (templateParameter.getName() == null || templateParameter.getName().length() == 0) continue;
                    httpRequest.addParameter("TP" + tpCount, templateParameter.getName());
                    int tdCount = 1;
                    for (Object value : templateParameter.getTextDatasets()) {
                        httpRequest.addParameter("TD" + tpCount + "_" + tdCount++, value);
                    }
                    ++tpCount;
                }
                boolean bl = true;
                for (AttachedParameter attachedParameter : apiParam.getAttachedParameters()) {
                    void var7_9;
                    if (attachedParameter.getInnerContent() == null) continue;
                    httpRequest.addParameter(String.valueOf(attachedParameter.getVerb()) + (int)var7_9, attachedParameter.getInnerContent());
                    httpRequest.addParameterIfNotNull("ACN" + (int)var7_9, attachedParameter.getName());
                    if (attachedParameter instanceof TextAttachedParameter) {
                        httpRequest.addParameter("ACC" + (int)var7_9, ((TextAttachedParameter)attachedParameter).getCharset());
                    }
                    ++var7_9;
                }
                for (Map.Entry<String, String> entry : this.additionalParams.entrySet()) {
                    httpRequest.addParameter(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, String> entry : apiParam.additionalParams().entrySet()) {
                    httpRequest.addParameter(entry.getKey(), entry.getValue());
                }
                Object var7_12 = null;
                if (mode == 2) {
                    MailParameter mailParameter = apiParam.getMail();
                    httpRequest.addParameter("MF", mailParameter.getFrom());
                    httpRequest.addParameterIfNotNull("MR", mailParameter.getReplyTo());
                    if (mailParameter.getUseFromForEnvelopeFrom()) {
                        httpRequest.addParameter("MEF", "1");
                    }
                    httpRequest.addParameterIfNotNull("MSJ", mailParameter.getSubject());
                    httpRequest.addParameterIfNotNull("MB", mailParameter.getBody());
                    httpRequest.addParameterIfNotNull("MA", mailParameter.getAttachName());
                    httpRequest.addParameter("MT", OPROARTSHandler.listToString(mailParameter.getMts()));
                    if (mailParameter.getMccs().size() > 0) {
                        httpRequest.addParameter("MCC", OPROARTSHandler.listToString(mailParameter.getMccs()));
                    }
                    if (mailParameter.getMbcs().size() > 0) {
                        httpRequest.addParameter("MBC", OPROARTSHandler.listToString(mailParameter.getMbcs()));
                    }
                    InputStream in = httpRequest.request();
                    try {
                        BufferedInputStream bis = new BufferedInputStream(in);
                        try {
                            byte[] buf = new byte[1024];
                            while (bis.read(buf) != -1) {
                            }
                            break block32;
                        }
                        finally {
                            bis.close();
                        }
                    }
                    catch (IOException e) {
                        throw new OPROARTSAPIException(e);
                    }
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpRequest.request());
                try {
                    try {
                        int dot;
                        String ext = null;
                        String fileName = httpRequest.lastResponseInfo().getFileName();
                        if (fileName != null && (dot = (fileName = new File(fileName).getName()).lastIndexOf(46)) != -1) {
                            ext = fileName.substring(dot);
                        }
                        if (ext == null) {
                            ext = OPROARTSHandler.formatToExtension(mode == 4 ? 3 : apiParam.getFormat());
                        }
                        string = String.valueOf(OPROARTSHandler.includeTrailingPathDelimiter(dir)) + name + ext;
                        this.save(bufferedInputStream, string);
                    }
                    finally {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new OPROARTSAPISavingException(e);
                }
                if (this.checkSavedSize && (contentLength = httpRequest.lastResponseInfo().getContentLength()) != -1L && (size = new File(string).length()) != contentLength) {
                    throw new OPROARTSAPIFileSizeException(string, size, contentLength);
                }
            }
            apiParam.setResponseInfo(httpRequest.lastResponseInfo());
            void var14_35 = var7_14;
            return var14_35;
        }
        finally {
            httpRequest.disconnect();
        }
    }

    private static String includeTrailingPathDelimiter(String path) {
        return path != null && !path.equals("") ? (path.lastIndexOf(File.separator) == path.length() - 1 ? path : String.valueOf(path) + File.separator) : File.separator;
    }

    private void save(InputStream is, String path) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            bos.flush();
        }
        finally {
            bos.close();
        }
    }

    protected static void checkSavable(String dir, String name, int format) throws OPROARTSAPISavingException {
        File d = new File(dir);
        if (d.isFile()) {
            throw new OPROARTSAPISavingException("File with the same name as specified directory exists (" + d.getAbsolutePath() + ").");
        }
        d.mkdirs();
        if (!d.isDirectory()) {
            throw new OPROARTSAPISavingException("Could not make directory (" + d.getAbsolutePath() + ").");
        }
        if (4 == format) {
            return;
        }
        if (5 == format || 6 == format) {
            return;
        }
        if (7 == format || 8 == format) {
            return;
        }
        File f = new File(OPROARTSHandler.createFileName(dir, name, format));
        if (f.exists()) {
            if (f.isDirectory()) {
                throw new OPROARTSAPISavingException("Directory with the same name as document which will be saved already exists (" + f.getAbsolutePath() + ").");
            }
            if (!f.canWrite()) {
                throw new OPROARTSAPISavingException("File with the same name as document which will be saved cannot be overwritten (" + f.getAbsolutePath() + ").");
            }
        } else {
            boolean needDelete = true;
            try {
                try {
                    needDelete = f.createNewFile();
                    if (!needDelete) {
                        throw new OPROARTSAPISavingException("Could not create file to save document (" + f.getAbsolutePath() + ").");
                    }
                }
                catch (IOException e) {
                    throw new OPROARTSAPISavingException("Could not create file to save document (" + f.getAbsolutePath() + ").");
                }
            }
            finally {
                if (needDelete) {
                    f.delete();
                }
            }
        }
    }

    protected static void checkParameter(OPROARTSParameter p, boolean checkTemplate, boolean checkFormat, boolean checkMail) throws IllegalArgumentException {
        if (p == null) {
            throw new IllegalArgumentException("OPROARTSParameter is not omissible.");
        }
        if (p.getCid() == null || p.getCid().length() == 0) {
            throw new IllegalArgumentException("CID is not omissible.");
        }
        if (p.getUid() == null || p.getUid().length() == 0) {
            throw new IllegalArgumentException("UID is not omissible.");
        }
        if (p.getUpw() == null || p.getUpw().length() == 0) {
            throw new IllegalArgumentException("Password for UID is not omissible.");
        }
        if (checkTemplate) {
            if (p.getTemplateParameters() == null || p.getTemplateParameters().size() == 0) {
                throw new IllegalArgumentException("TemplateParameter is not omissible.");
            }
            for (TemplateParameter tp : p.getTemplateParameters()) {
                if (tp.getName() != null && tp.getName().length() != 0) continue;
                throw new IllegalArgumentException("name of TemplateParameter is not omissible.");
            }
        }
        if (checkFormat) {
            boolean hit = false;
            int[] nArray = PUBLIC_FORMAT;
            int n = PUBLIC_FORMAT.length;
            int n2 = 0;
            while (n2 < n) {
                int format = nArray[n2];
                if (p.getFormat() == format) {
                    hit = true;
                    break;
                }
                ++n2;
            }
            if (!hit) {
                throw new IllegalArgumentException("Invalid format value.");
            }
        }
        if (checkMail) {
            if (p.getMail() == null) {
                throw new IllegalArgumentException("MailParameter is not omissible.");
            }
            if (p.getMail().getFrom() == null || p.getMail().getFrom().length() == 0) {
                throw new IllegalArgumentException("From address of MailParameter is not omissible.");
            }
            if (!MAIL_ADDRESS.matcher(p.getMail().getFrom()).matches()) {
                throw new IllegalArgumentException("From addresses of MailParameter is not a mail address (" + p.getMail().getFrom() + ").");
            }
            if (p.getMail().getMts().size() == 0) {
                throw new IllegalArgumentException("TO address of MailParameter is not omissible.");
            }
            if (p.getMail().getReplyTo() != null && !MAIL_ADDRESS.matcher(p.getMail().getReplyTo()).matches()) {
                throw new IllegalArgumentException("Reply-To addresses of MailParameter is not a mail address (" + p.getMail().getReplyTo() + ").");
            }
            for (String s : p.getMail().getMts()) {
                if (MAIL_ADDRESS.matcher(s).matches()) continue;
                throw new IllegalArgumentException("One of the TO addresses of MailParameter is not a mail address (" + s + ").");
            }
            for (String s : p.getMail().getMccs()) {
                if (MAIL_ADDRESS.matcher(s).matches()) continue;
                throw new IllegalArgumentException("One of the CC addresses of MailParameter is not a mail address (" + s + ").");
            }
            for (String s : p.getMail().getMbcs()) {
                if (MAIL_ADDRESS.matcher(s).matches()) continue;
                throw new IllegalArgumentException("One of the BCC addresses of MailParameter is not a mail address (" + s + ").");
            }
        }
    }

    protected static String createFileName(String dir, String name, int format) {
        return String.valueOf(OPROARTSHandler.includeTrailingPathDelimiter(dir)) + name + OPROARTSHandler.formatToExtension(format);
    }

    private static String formatToExtension(int format) {
        switch (format) {
            case 3: {
                return ".odp";
            }
            case 1: {
                return ".opr";
            }
            case 4: {
                return ".xlsx";
            }
            case 5: {
                return ".xlsx";
            }
            case 7: {
                return ".xlsx";
            }
            case 6: {
                return ".docx";
            }
            case 8: {
                return ".docx";
            }
        }
        return ".pdf";
    }

    protected static String listToString(List<String> l) {
        StringBuffer result = new StringBuffer();
        Iterator<String> iter = l.iterator();
        while (iter.hasNext()) {
            result.append(iter.next()).append(',');
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    protected static OPROARTSHTTPRequest makeAuthParameteredRequest(OPROARTSHandler handler, OPROARTSParameter parameter) {
        OPROARTSHTTPRequest result = new OPROARTSHTTPRequest(handler.url, handler.proxy, handler.connectTimeout, handler.readTimeout);
        result.setLocale(handler.getLocale());
        result.setUaDetail(handler.uaDetail);
        result.addParameter("CID", parameter.getCid());
        result.addParameter("UID", parameter.getUid());
        result.addParameter("UPW", parameter.getUpw());
        return result;
    }

    protected static OPROARTSAPIException makeOPROARTSAPIException(Throwable cause) {
        return new OPROARTSAPIException(cause);
    }

    protected static String join(Iterable<String> list, String separator) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (!first) {
                result.append(separator);
            }
            result.append(s);
            first = false;
        }
        return result.toString();
    }

    static class Base64StreamHolder {
        private final InputStream in;

        public Base64StreamHolder(InputStream in) {
            this.in = in;
        }

        public InputStream getStream() {
            return this.in;
        }

        public long encode(Writer out) throws IOException {
            return Base64.encodeTo(this.in, out, false, true);
        }
    }

    protected static final class OPROARTSHTTPRequest {
        private final URL url;
        private final Proxy proxy;
        private final Map<String, Object> params = new LinkedHashMap<String, Object>();
        private final int connectTimeout;
        private final int readTimeout;
        private HttpURLConnection urlCon = null;
        private Locale locale = null;
        private String uaDetail;
        private OPROARTSResponseInfo lastResponseInfo;

        public OPROARTSHTTPRequest(URL url, int connectTimeout, int readTimeout) {
            this(url, null, connectTimeout, readTimeout);
        }

        public OPROARTSHTTPRequest(URL url, Proxy proxy, int connectTimeout, int readTimeout) {
            this.proxy = proxy;
            this.connectTimeout = connectTimeout < 0 ? 0 : connectTimeout;
            this.readTimeout = readTimeout < 0 ? 0 : readTimeout;
            this.url = url;
        }

        public void setLocale(Locale value) {
            this.locale = value;
        }

        public void setUaDetail(String value) {
            this.uaDetail = value;
        }

        public void addParameter(String name, Object value) {
            if (value == null) {
                value = "";
            }
            this.params.put(name, value);
        }

        public void addParameterIfNotNull(String name, Object value) {
            if (value != null) {
                this.params.put(name, value);
            }
        }

        private HttpURLConnection makeConnection(String urlStr) throws OPROARTSAPIException {
            try {
                return this.makeConnection(new URL(urlStr));
            }
            catch (MalformedURLException e) {
                throw new OPROARTSAPIConnectionException(e);
            }
        }

        private HttpURLConnection makeConnection(URL url) throws OPROARTSAPIException {
            try {
                this.urlCon = this.proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(this.proxy);
                this.urlCon.setConnectTimeout(this.connectTimeout);
                this.urlCon.setReadTimeout(this.readTimeout);
                if (this.urlCon instanceof HttpsURLConnection) {
                    SSLContext ssl = SSLContext.getInstance("SSL");
                    ssl.init(null, trustManagers, null);
                    ((HttpsURLConnection)this.urlCon).setSSLSocketFactory(ssl.getSocketFactory());
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new OPROARTSAPIException(e);
            }
            catch (KeyManagementException e) {
                throw new OPROARTSAPIException(e);
            }
            catch (IOException e) {
                throw new OPROARTSAPIConnectionException(e);
            }
            String ua = OPROARTSHandler.USERAGENT;
            if (this.uaDetail != null && this.uaDetail.length() > 0) {
                ua = String.valueOf(ua) + " " + this.uaDetail;
            }
            this.urlCon.setRequestProperty("User-Agent", ua);
            return this.urlCon;
        }

        public InputStream request() throws OPROARTSAPIException, OPROARTSException {
            String ENCODE = "UTF-8";
            try {
                int status;
                this.urlCon = this.makeConnection(this.url);
                this.urlCon.setRequestMethod("POST");
                this.urlCon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                Locale locale = this.locale != null ? this.locale : Locale.getDefault();
                this.urlCon.setRequestProperty("Accept-Language", locale.getLanguage());
                this.urlCon.setInstanceFollowRedirects(false);
                this.urlCon.setDoOutput(true);
                this.urlCon.setDoInput(true);
                try {
                    this.urlCon.connect();
                }
                catch (SocketTimeoutException e) {
                    throw new OPROARTSAPIConnectTimeoutException(e);
                }
                BufferedWriter out = new BufferedWriter(new SimpleWriter(new BufferedOutputStream(this.urlCon.getOutputStream())));
                try {
                    for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                        String name = entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) {
                            value = "";
                        }
                        if (value instanceof String) {
                            out.write(String.valueOf(name) + "=");
                            WriterURLEncoder.encode((String)value, (Writer)out, "UTF-8");
                            out.write("&");
                            continue;
                        }
                        if (value instanceof Reader) {
                            out.write(String.valueOf(name) + "=");
                            WriterURLEncoder.encode((Reader)value, (Writer)out, "UTF-8");
                            out.write("&");
                            continue;
                        }
                        if (!(value instanceof Base64StreamHolder)) continue;
                        out.write(String.valueOf(name) + "=");
                        out.flush();
                        ((Base64StreamHolder)value).encode(out);
                        out.write("&");
                    }
                }
                finally {
                    out.flush();
                    out.close();
                }
                CookieManager cm = null;
                while ((status = this.urlCon.getResponseCode()) == 302 || status == 201 || status == 202) {
                    if (cm == null) {
                        cm = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
                    }
                    cm.put(this.urlCon.getURL().toURI(), this.urlCon.getHeaderFields());
                    String next = this.urlCon.getHeaderField("location");
                    this.urlCon.disconnect();
                    if (Thread.currentThread().isInterrupted()) {
                        throw new OPROARTSAPIException("interrupted");
                    }
                    this.urlCon = this.makeConnection(next);
                    this.urlCon.setRequestMethod("GET");
                    this.urlCon.setRequestProperty("Accept-Language", locale.getLanguage());
                    this.urlCon.setInstanceFollowRedirects(false);
                    Map<String, List<String>> cookies = cm.get(this.urlCon.getURL().toURI(), this.urlCon.getRequestProperties());
                    if (cookies != null && !cookies.isEmpty()) {
                        for (Map.Entry<String, List<String>> entry : cookies.entrySet()) {
                            List<String> values = entry.getValue();
                            if (values == null || values.isEmpty()) continue;
                            this.urlCon.addRequestProperty(entry.getKey(), OPROARTSHandler.join(values, "; "));
                        }
                    }
                    try {
                        this.urlCon.connect();
                    }
                    catch (SocketTimeoutException e) {
                        throw new OPROARTSAPIConnectTimeoutException(e);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    throw new OPROARTSAPIException("interrupted");
                }
                int statusCode = this.urlCon.getResponseCode();
                this.lastResponseInfo = new OPROARTSResponseInfo(this.urlCon.getHeaderFields());
                if (statusCode >= 400) {
                    String message = this.lastResponseInfo.getErrorMessage();
                    if (message == null || message.length() == 0) {
                        message = this.urlCon.getResponseMessage();
                    }
                    switch (statusCode) {
                        case 401: {
                            throw new OPROARTSUnAuthorizedException(message);
                        }
                        case 402: {
                            throw new OPROARTSRestrictedException(message);
                        }
                        case 403: {
                            throw new OPROARTSIllegalRequestException(message);
                        }
                        case 413: {
                            throw new OPROARTSRequestTooLargeException(message);
                        }
                        case 503: {
                            throw new OPROARTSConcurrentRequestException(message);
                        }
                        case 500: {
                            throw new OPROARTSException(message);
                        }
                        case 404: {
                            throw new FileNotFoundException(message);
                        }
                        case 408: {
                            throw new OPROARTSTimeoutException(message);
                        }
                        case 410: {
                            throw new OPROARTSCanceledException(message);
                        }
                    }
                    throw new OPROARTSException(message);
                }
                return this.urlCon.getInputStream();
            }
            catch (SocketTimeoutException e) {
                throw new OPROARTSAPIReadTimeoutException(e);
            }
            catch (IOException e) {
                throw new OPROARTSAPIConnectionException(e);
            }
            catch (URISyntaxException e) {
                throw new OPROARTSAPIException(e);
            }
        }

        public void disconnect() {
            if (this.urlCon != null) {
                this.urlCon.disconnect();
            }
        }

        public OPROARTSResponseInfo lastResponseInfo() {
            return this.lastResponseInfo;
        }
    }
}

